C     ******************************************************************
C
C     ROCK, PAPER, SCISSORS
C
C     ORIGINAL BASIC VERSION WRITTEN BY CHARLES LUND. MODIFIED AND
C     PUBLISHED BY DAVID H. AHL. CONVERTED TO FORTRAN BY PHILIPP ENGEL.
C
C     ******************************************************************
      PROGRAM RockPaperScissors
      INTEGER     I, ICOMP, ICOMPC, IPLAY, IPLAYC, ISTAT, NGAMES
      CHARACTER*8 NAMES(3)
      INTEGER     RULES(3)
      COMMON /GLOBAL/ NAMES, RULES
      DATA ICOMPC, IPLAYC /0,0/

      CALL SRAND(TIME())
      PRINT 100
C
C     ASK PLAYER HOW MANY GAMES TO PLAY.
C
   10 CONTINUE
      PRINT 110
      READ (*, 300, IOSTAT=ISTAT) NGAMES

      IF (ISTAT .NE. 0 .OR. NGAMES .LT. 1) THEN
        PRINT 120
        GOTO 10
      END IF

      IF (NGAMES .GT. 10) THEN
        PRINT 130
        GOTO 10
      END IF
C
C     THE MAIN LOOP.
C
      DO 20 I = 1, NGAMES
      ICOMP = 1 + INT(RAND(0) * 3)
      PRINT 140, I
C
C     READ PLAYER'S CHOICE.
C
   30 CONTINUE
      READ (*, 300, IOSTAT=ISTAT) IPLAY
      IF ((IPLAY - 1) * (IPLAY - 2) * (IPLAY - 3) .NE. 0) THEN
        PRINT 120
        GOTO 30
      END IF

      PRINT 150, NAMES(IPLAY)
      PRINT 160, NAMES(ICOMP)
C
C     DETERMINE THE WINNER.
C
      IF (IPLAY .EQ. ICOMP) THEN
        PRINT 170
      ELSE IF (RULES(IPLAY) .EQ. ICOMP) THEN
        PRINT 180
        IPLAYC = IPLAYC + 1
      ELSE
        PRINT 190
        ICOMPC = ICOMPC + 1
      END IF
   20 CONTINUE
C
C     OUTPUT GAME SCORE.
C
      PRINT 200, ICOMPC, IPLAYC, NGAMES - (ICOMPC + IPLAYC)

  100 FORMAT (21X,' GAME OF ROCK, PAPER, SCISSORS',/,
     &26X,' CREATIVE COMPUTING',/,24X,' MORRISTOWN, NEW JERSEY')
  110 FORMAT (/,' HOW MANY GAMES?')
  120 FORMAT (' INVALID INPUT.')
  130 FORMAT (' SORRY, BUT WE AREN''T ALLOWED TO PLAY THAT MANY.')
  140 FORMAT (/,' GAME NUMBER:',I2,/
     &' 1) ROCK 2) PAPER 3) SCISSORS',/,
     &' WHAT IS YOUR CHOICE?')
  150 FORMAT (' YOU HAVE CHOSEN:         ',A)
  160 FORMAT (' THE COMPUTER HAS CHOSEN: ',A)
  170 FORMAT (' TIE GAME. NO WINNER.')
  180 FORMAT (' YOU WIN!')
  190 FORMAT (' THE COMPUTER WINS!')
  200 FORMAT (/,' HERE IS THE FINAL GAME SCORE:',/,
     &' THE COMPUTER HAS WON ',I2,' GAME(S),',/,
     &' YOU HAVE WON ',I2,' GAME(S),'/,
     &' AND ',I2,' GAME(S) ENDED IN A TIE.',/,/,' THANKS FOR PLAYING!')
  300 FORMAT (I2)
      END
C     ******************************************************************
      BLOCK DATA
C
C     COMMON VARIABLES:
C
C     NAMES - STRING ARRAY WITH THE THREE SYMBOL NAMES.
C     RULES - THE GAME RULES: 1 BEATS 3, 2 BEATS 1, AND 3 BEATS 2.
C
      CHARACTER*8 NAMES(3)
      INTEGER     RULES(3)
      COMMON /GLOBAL/ NAMES, RULES
      DATA NAMES /'ROCK','PAPER','SCISSORS'/
      DATA RULES /3,1,2/
      END
